﻿<%@ WebHandler Language="C#" Class="OleHandler" %>

using System;
using System.Web;
using System.Web.SessionState;

public class OleHandler : IHttpHandler, IRequiresSessionState
{
    public void ProcessRequest(HttpContext Context)
    {
        Chukeh.Data.IResult _Result;
        Chukeh.Data.OleProvider _Provider = new Chukeh.Data.OleProvider("Data Source=~App_Data\\Data.mdb;Provider=Microsoft.Jet.OLEDB.4.0");
        switch (Context.Request.Params["Command"])
        {
            case "Add":
                if (Chukeh.Base.IsNull(Context.Request.Params["Name"]))
                {
                    Chukeh.Data.IResult.CurrentResult(new Chukeh.Data.IResult(3, "名称不能为空"));
                }
                else
                {
                    //  执行插入操作
                    _Result = _Provider.RunInsert("DB_TABLE", true, false, Chukeh.Current.Querys);
                    //  写入操作结果信息
                    Chukeh.Data.IResult.CurrentResult(_Result);
                }
                Context.Response.Redirect("List.aspx?d=" + DateTime.Now.Ticks.ToString("x"));
                break;
            case "Edit":
                //  执行插入操作
                _Result = _Provider.RunUpdate("DB_TABLE", true, false, Chukeh.Current.Querys);
                //  写入操作结果信息
                Chukeh.Data.IResult.CurrentResult(_Result);
                //  跳转至列表页
                Context.Response.Redirect("List.aspx?d=" + DateTime.Now.Ticks.ToString("x"));
                break;
            case "Delete":
                //  执行插入操作
                _Result = _Provider.RunDelete("DB_TABLE", Chukeh.Current.Querys);
                //  写入操作结果信息
                Chukeh.Data.IResult.CurrentResult(_Result);
                //  跳转至列表页
                Context.Response.Redirect("List.aspx?d=" + DateTime.Now.Ticks.ToString("x"));
                break;
            default:
                break;
        }
        _Provider.Dispose();
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
}